#ifndef _CE2_CONFIG_H
#define _CE2_CONFIG_H

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_public.h"

/*
*  Object %CE2_config.h    : %
*/
/** @file
*  \brief This file contains all of the enums and definitions 
*         that are used for configuration of CryptoEngine2
*
*  \version CE2_config.h#
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Defines ******************************/

#ifdef WIN32

#ifndef QAT_CRYPTOENGINE2_EXPORTS
#define CE2CIMPORT_C 
#else
#define CE2CIMPORT_C __declspec(dllexport)
#endif

#else

#define CE2CIMPORT_C 

#define MIN(a,b) (((a)<(b))?(a):(b))
#define min(a,b) (((a)<(b))?(a):(b))

#endif

/* For properly work of LibTomCrypt */
#ifndef LTM_DESC
#define LTM_DESC
#endif

/************************ Enums ********************************/
/************************ Typedefs  ****************************/
/*********************** Structures ****************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/

#endif /* ifndef _CE2_CONFIG_H*/
